<?php
header("Content-type: text/plain; charset=utf-8");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);

if (!defined('FastCore') || FastCore !== true) { Header('Location: /404'); return; }
if (!isset($_SESSION['uid'])) { exit(); }

$csrfCheck = $func->csrfVerify();
if(isset($_POST['edit']) && $csrfCheck == TRUE) {

	$surf_id = filter_var($_POST['surf_id'],FILTER_SANITIZE_NUMBER_INT);
	$title = filter_var($_POST['title'], FILTER_SANITIZE_STRING);
	$url = $func->validUrl(trim($_POST['url']));
	
	$timers = filter_var($_POST['timer'], FILTER_SANITIZE_NUMBER_INT);
	$wind = filter_var($_POST['wind'], FILTER_SANITIZE_NUMBER_INT);
	$vip = filter_var($_POST['vip'], FILTER_SANITIZE_NUMBER_INT);
	$reply = filter_var($_POST['reply'], FILTER_SANITIZE_NUMBER_INT);

	if($serf_id === FALSE && empty($data)){
		$data['error'] = 'Неверные данные!';
		$data['id'] = 'surf_id';
	}
	if($title === FALSE && empty($data)){
		$data['error'] = 'Неверно указано название!';
		$data['id'] = 'title';
	}
	if($url === FALSE && empty($data)){
		$data['error'] = 'Неверно указана ссылка!';
		$data['id'] = 'url';
	}
	if (iconv_strlen($title) > 65) {
		$data['error'] = 'В поле Названия можно написать только 65 символов!';
		$data['id'] = '';
	}
	if (strlen($url) > 255) {
		$data['error'] = 'В поле URL можно написать только 255 символов!';
		$data['id'] = '';
	}
	if ($timers === FALSE || $wind === FALSE || $vip === FALSE || $reply === FALSE && empty($data)) {
		$data['error'] = 'Не удалось определить значение!';
		$data['id'] = '';
	}
	if (intval($vip > 1) || intval($wind > 1) || intval($reply > 1)) {
		$data['error'] = 'Такого значения не существует!';
		$data['id'] = '';
	}

    if(empty($data)){
		$numbe =  $db->query('SELECT uid FROM db_surf WHERE id = ?', array($surf_id))->numRows();
        if($numbe > 0){
			$data_surf = $db->query('SELECT uid FROM db_surf WHERE id = ?', array($surf_id))->fetchArray();
			$owner = $data_surf['uid'];
            if($uid != $data_surf['uid']){
				$data['error'] = "Ссылка вам не преадлежит!";
			}
		} else {
			$data['error'] = 'Ссылка не существует!';
        }
    }
	if(!empty($data)){
		$data['status'] = 'error';
		$data['title'] = 'Ошибка';
		$data['redirect'] = '';
	}
	if(empty($data)){
	$surf = $db->query('SELECT * FROM db_surf_config WHERE id = ?', array(1))->fetchArray();

	$timer = isset($_POST['timer']) ? (int)$_POST['timer'] : $surf['timer'];
	$timerArr = array($timer, $timer*2, $timer*3, $timer*4, $timer*5,$timer*6);

	if ($timer == 10) { $selTimer = $timerArr[0]; $buyTimer += $surf['timer_pay']; } 
	if ($timer == 20) { $selTimer = $timerArr[0]; $buyTimer += ($surf['timer_pay'] * 2); } 
	if ($timer == 30) { $selTimer = $timerArr[0]; $buyTimer += ($surf['timer_pay'] * 3); }
	if ($timer == 40) { $selTimer = $timerArr[0]; $buyTimer += ($surf['timer_pay'] * 4); }
	if ($timer == 50) { $selTimer = $timerArr[0]; $buyTimer += ($surf['timer_pay'] * 5); }
	if ($timer == 60) { $selTimer = $timerArr[0]; $buyTimer += ($surf['timer_pay'] * 6); }
	
	$priceTimer = number_format($buyTimer, 2, '.', ''); // Цена таймера
	$timerAd = $selTimer; // Таймер

	if ($wind == 1) { $priceWind = $surf['wind']; } else { $priceWind = 0.00; }
	if ($vip == 1) { $priceVip = $surf['vip']; } else { $priceVip = 0.00; }
	if ($reply == 1) { $period = 12; } else { $period = 24; }

	$priceAd = $surf['price_click']+$priceTimer+$priceWind+$priceVip; // Цена рекламодателю
	$perAd = $surf['per_click']+$priceTimer+$priceWind; // Цена исполнителю

	$datas_edit = $db->query('SELECT * FROM db_surf WHERE id = ?', array($surf_id))->fetchArray();
	$balanceSurf = $datas_edit['balance'];
	
	$editLinkSurf = $db->query('UPDATE db_surf SET title = ?, url = ?, timer = ?, wind = ?, vip = ?, reply = ?, price_click = ?, per_click = ?, balance = ?, status = ? WHERE id = ?', $title, $url, $timerAd, $wind, $vip, $period, $priceAd, $perAd, $balanceSurf, '2', $surf_id);
    $editLinkSurf = $db->close();
	
	$data['status'] = 'success';
	$data['title'] = 'Успешно';
	$data['error'] = 'Вы успешно отредактировали серфинг!';
	$data['redirect'] = '/user/surf/links';
	}
} else {
	$data['status'] = 'error';
	$data['title'] = 'Ошибка';
	$data['error'] = 'Ошибка данных';
	$data['redirect'] = '';
}
echo json_encode($data);