<?php
header("Content-type: text/plain; charset=utf-8");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);

if (!defined('FastCore') || FastCore !== true) { Header('Location: /404'); return; }
if (!isset($_SESSION['uid'])) { exit(); }

if (!empty($_POST['surf_id'])) {
	$surf_id = filter_var($_POST['surf_id'], FILTER_SANITIZE_NUMBER_INT);

	if ($surf_id === FALSE) {
		$data['error'] = 'Неверные данные!';
	}

    if(empty($data)){
		$numbst =  $db->query('SELECT uid FROM db_surf WHERE id = ?', array($surf_id))->numRows();
        if($numbst > 0){
			$data_surf = $db->query('SELECT uid, balance FROM db_surf WHERE id = ?', array($surf_id))->fetchArray();
			$owner = $data_surf['uid'];
            if($uid != $owner){
				$data['error'] = "Ссылка вам не принадлежит!";
			}
		} else {
			$data['error'] = 'Ссылка не существует!';
        }
    }
	
	if (!empty($data)) {
		$data['status'] = 'error';
		$data['title'] = 'Ошибка';
		$data['redirect'] = '';
	}
	if (empty($data)) {
		
		$moneyBack = $data_surf['balance'];
		$owner = $data_surf['uid'];
		
		$db->query('UPDATE db_users SET money_b = money_b + ? WHERE id = ?',array($moneyBack, $owner));
		$db->query('DELETE FROM db_surf WHERE id = ?',array($surf_id));
		$db->close();
		
		$data['status'] = 'success';
		$data['title'] = 'Успешно';
		$data['error'] = 'Вы успешно удалили ссылку, средства вам возвращены!';
		$data['redirect'] = '';
	}
}else{
	$data['status'] = 'error';
	$data['title'] = 'Ошибка';
	$data['error'] = 'Ошибка данных';
	$data['redirect'] = '';
}
echo json_encode($data);